package mole.entities.triggers 
{
	import mole.Main;
	import net.flashpunk.graphics.Image;
	import net.flashpunk.Entity;
	import net.flashpunk.graphics.Spritemap;
	
	/**
	 * Trigger qui active le nouveau point de respawn.
	 * @author Cédric Liaudet
	 */
	public class CRespawn extends CTrigger
	{
		//[Embed(source = '../../../data/images/checkpoint_red.png')]
		//private const RED:Class;
		
		//[Embed(source = '../../../data/images/checkpoint_green.png')]
		//private const GREEN:Class;
			
		/**
		 * Constructeur par défaut
		 * @param	_bOnce flag pour indiquer si on doit jouer le trigger qu'une seul fois
		 * @param	_Func Callback quand le trigger est activé
		 * @param	_aTypes Types accepter pour l'activation.
		 * @param	_iWith Largeur du trigger
		 * @param	_iHeight Hauteur du trigger.
		 */
		public function CRespawn(_bOnce:Boolean, _Func:Function, _aTypes:Array, _iWith:int, _iHeight:int, _iPosX:int, _iPosY:int) 
		{
			super(_bOnce, OnActivated, _aTypes, _iWith, _iHeight);
			
			x = _iPosX;
			y = _iPosY;
			
			// creation d'une entité a partir de l'image.
			//var image:Image = new Image(RED);
			//m_CheckPoint = Main.World.addGraphic(image);
			m_CheckPoint.x = x;
			m_CheckPoint.y = y;
			//m_CheckPoint.setHitbox(image.width, image.height);
			
			// On positionne l'entité sur le sol le plus proche.
			Main.World.SnapToFloor(m_CheckPoint);
		}
		
		/**
		 * Callback lors de l'activation.
		 */
		public function OnActivated():void
		{
			//m_CheckPoint.graphic = new Image(GREEN);
			Main.GameRules.SetRespawnPoint(x, y);
		}

		private var m_CheckPoint:Entity; ///< Représentation graphique.
	}

}